/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Point;
import jclass.bwt.JCSerializable;
import jclass.chart.Changeable;
import jclass.chart.JCChartStyle;

public class JCPieChartFormat
implements JCSerializable {
    private String otherLabel;
    private JCChartStyle otherStyle = new JCChartStyle();
    int thresholdMethod = 0;
    double thresholdValue = 10.0;
    int sortOrder = 0;
    int minSlices = 5;
    Point[] explodeList;
    int explodeOffset = 10;
    Changeable parent;
    public static final int SLICE_CUTOFF = 0;
    public static final int PIE_PERCENTILE = 1;
    public static final int DATA_ORDER = 0;
    public static final int ASCENDING_ORDER = 1;
    public static final int DESCENDING_ORDER = 2;
    public static final int OTHER_SLICE = -10;

    public JCPieChartFormat() {
    }

    public JCPieChartFormat(Changeable changeable) {
        this.parent = changeable;
    }

    public int getThresholdMethod() {
        return this.thresholdMethod;
    }

    public synchronized void setThresholdMethod(int n) {
        if (n == this.thresholdMethod) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                this.thresholdMethod = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for ThresholdMethod in JCPieChartFormat.  Must be one of SLICE_CUTOFF or PIE_PERCENTILE");
            }
        }
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public double getThresholdValue() {
        return this.thresholdValue;
    }

    public synchronized void setThresholdValue(double d) {
        if (d == this.thresholdValue) {
            return;
        }
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("ThresholdValue must be between 0.0 and 100.0");
        }
        this.thresholdValue = d;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public synchronized void setSortOrder(int n) {
        if (n == this.sortOrder) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.sortOrder = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for SortOrder in JCPieChartFormat.  Must be one of ASCENDING_ORDER, DESCENDING_ORDER or DATA_ORDER");
            }
        }
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public int getMinSlices() {
        return this.minSlices;
    }

    public synchronized void setMinSlices(int n) {
        if (this.minSlices == n) {
            return;
        }
        this.minSlices = n;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public String getOtherLabel() {
        if (this.otherLabel == null) {
            this.otherLabel = new String("Other");
        }
        return this.otherLabel;
    }

    public synchronized void setOtherLabel(String string) {
        if (this.otherLabel.equals(string)) {
            return;
        }
        this.otherLabel = string;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public JCChartStyle getOtherStyle() {
        return this.otherStyle;
    }

    public synchronized void setOtherStyle(JCChartStyle jCChartStyle) {
        if (jCChartStyle == null) {
            return;
        }
        this.otherStyle = jCChartStyle;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public Point[] getExplodeList() {
        return this.explodeList;
    }

    public synchronized void setExplodeList(Point[] pointArray) {
        this.explodeList = pointArray;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public int getExplodeOffset() {
        return this.explodeOffset;
    }

    public synchronized void setExplodeOffset(int n) {
        this.explodeOffset = n;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }
}

